/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.spawning;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import lotr.common.LOTRConfig;
import lotr.common.LOTRGreyWandererTracker;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.LOTRPotions;
import lotr.common.entity.LOTREntities;
import lotr.common.entity.LOTREntityInvasionSpawner;
import lotr.common.entity.npc.LOTREntityBandit;
import lotr.common.world.LOTRWorldProvider;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.spawning.LOTRBiomeInvasionSpawns;
import lotr.common.world.spawning.LOTRGollumSpawner;
import lotr.common.world.spawning.LOTRInvasions;
import lotr.common.world.spawning.LOTRSpawnerNPCs;
import lotr.common.world.spawning.LOTRTravellingTraderSpawner;
import net.minecraft.block.Block;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.event.ForgeEventFactory;

public class LOTREventSpawner {
    private static Set<ChunkCoordIntPair> eligibleSpawnChunks = new HashSet<ChunkCoordIntPair>();
    public static List<LOTRTravellingTraderSpawner> travellingTraders = new ArrayList<LOTRTravellingTraderSpawner>();
    private static Set<Class> traderClasses = new HashSet<Class>();

    public static void createTraderSpawner(Class entityClass) {
        if (!traderClasses.contains(entityClass)) {
            traderClasses.add(entityClass);
            travellingTraders.add(new LOTRTravellingTraderSpawner(entityClass));
        }
    }

    public static void performSpawning(World world) {
        for (LOTRTravellingTraderSpawner trader : travellingTraders) {
            trader.performSpawning(world);
        }
        if (world.func_82737_E() % 20L == 0L) {
            LOTRSpawnerNPCs.getSpawnableChunksWithPlayerInRange(world, eligibleSpawnChunks, 32);
            List<ChunkCoordIntPair> shuffled = LOTRSpawnerNPCs.shuffle(eligibleSpawnChunks);
            if (LOTRConfig.enableBandits && world.field_73013_u != EnumDifficulty.PEACEFUL) {
                LOTREventSpawner.spawnBandits(world, shuffled);
            }
            if (LOTRConfig.enableInvasions && world.field_73013_u != EnumDifficulty.PEACEFUL) {
                LOTREventSpawner.spawnInvasions(world, shuffled);
            }
        }
        LOTRGollumSpawner.performSpawning(world);
        LOTRGreyWandererTracker.performSpawning(world);
    }

    private static void spawnInvasions(World world, List<ChunkCoordIntPair> spawnChunks) {
        Random rand = world.field_73012_v;
        block0: for (ChunkCoordIntPair chunkCoords : spawnChunks) {
            int k;
            int i;
            BiomeGenBase biome;
            ChunkPosition chunkposition = LOTRSpawnerNPCs.getRandomSpawningPointInChunk(world, chunkCoords);
            if (chunkposition == null || !((biome = world.func_72807_a(i = chunkposition.field_151329_a, k = chunkposition.field_151328_c)) instanceof LOTRBiome)) continue;
            LOTRBiomeInvasionSpawns invasionSpawns = ((LOTRBiome)biome).invasionSpawns;
            for (EventChance invChance : EventChance.values()) {
                int range;
                List<LOTRInvasions> invList = invasionSpawns.getInvasionsForChance(invChance);
                if (invList.isEmpty()) continue;
                final LOTRInvasions invasionType = invList.get(rand.nextInt(invList.size()));
                double chance = invChance.chancesPerSecondPerChunk[16];
                boolean playerHasEffect = world.field_73010_i.stream().filter(player -> player instanceof EntityPlayer).map(player -> (EntityPlayer)player).anyMatch(player -> ((EntityLivingBase)player).func_70644_a(LOTRPotions.curse));
                chance = playerHasEffect ? (chance *= 15.0) : (chance *= 1.0);
                if (!world.func_72935_r() && LOTRWorldProvider.isLunarEclipse()) {
                    chance *= 5.0;
                }
                if (rand.nextDouble() >= chance || world.func_82733_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(i - 48), (double)0.0, (double)(k - (range = 48)), (double)(i + range), (double)world.func_72800_K(), (double)(k + range)), new IEntitySelector(){

                    public boolean func_82704_a(Entity entity) {
                        EntityPlayer entityplayer;
                        if (entity instanceof EntityPlayer && (entityplayer = (EntityPlayer)entity).func_70089_S() && !entityplayer.field_71075_bZ.field_75098_d) {
                            return LOTRLevelData.getData(entityplayer).getAlignment(invasionType.invasionFaction) < 0.0f;
                        }
                        return false;
                    }
                }).isEmpty()) continue;
                for (int attempts = 0; attempts < 16; ++attempts) {
                    Block block;
                    int k1;
                    int i1 = i + MathHelper.func_76136_a((Random)rand, (int)-32, (int)32);
                    int j1 = world.func_72976_f(i1, k1 = k + MathHelper.func_76136_a((Random)rand, (int)-32, (int)32));
                    if (j1 <= 60 || (block = world.func_147439_a(i1, j1 - 1, k1)) != biome.field_76752_A && block != biome.field_76753_B || world.func_147439_a(i1, j1, k1).func_149721_r() || world.func_147439_a(i1, j1 + 1, k1).func_149721_r()) continue;
                    LOTREntityInvasionSpawner invasion = new LOTREntityInvasionSpawner(world);
                    invasion.setInvasionType(invasionType);
                    invasion.func_70012_b((double)i1 + 0.5, j1 += 3 + rand.nextInt(3), (double)k1 + 0.5, 0.0f, 0.0f);
                    if (!invasion.canInvasionSpawnHere()) continue;
                    world.func_72838_d((Entity)invasion);
                    invasion.selectAppropriateBonusFactions();
                    invasion.startInvasion();
                    continue block0;
                }
            }
        }
    }

    private static void spawnBandits(World world, List<ChunkCoordIntPair> spawnChunks) {
        Random rand = world.field_73012_v;
        block0: for (ChunkCoordIntPair chunkCoords : spawnChunks) {
            int range;
            int k;
            int i;
            BiomeGenBase biome;
            ChunkPosition chunkposition = LOTRSpawnerNPCs.getRandomSpawningPointInChunk(world, chunkCoords);
            if (chunkposition == null || !((biome = world.func_72807_a(i = chunkposition.field_151329_a, k = chunkposition.field_151328_c)) instanceof LOTRBiome)) continue;
            LOTRBiome lotrbiome = (LOTRBiome)biome;
            Class<? extends LOTREntityBandit> banditClass = lotrbiome.getBanditEntityClass();
            double chance = lotrbiome.getBanditChance().chancesPerSecondPerChunk[16];
            boolean playerHasEffect = world.field_73010_i.stream().filter(player -> player instanceof EntityPlayer).map(player -> (EntityPlayer)player).anyMatch(player -> ((EntityLivingBase)player).func_70644_a(LOTRPotions.curse));
            chance = playerHasEffect ? (chance *= 50.0) : (chance *= 1.0);
            if (chance <= 0.0 || world.field_73012_v.nextDouble() >= chance || world.func_82733_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(i - 48), (double)0.0, (double)(k - (range = 48)), (double)(i + range), (double)world.func_72800_K(), (double)(k + range)), LOTRMod.selectNonCreativePlayers()).isEmpty()) continue;
            int banditsSpawned = 0;
            int maxBandits = MathHelper.func_76136_a((Random)world.field_73012_v, (int)1, (int)6);
            for (int attempts = 0; attempts < 32; ++attempts) {
                LOTREntityBandit bandit;
                Block block;
                int k1;
                int i1 = i + MathHelper.func_76136_a((Random)rand, (int)-32, (int)32);
                int j1 = world.func_72976_f(i1, k1 = k + MathHelper.func_76136_a((Random)rand, (int)-32, (int)32));
                if (j1 <= 60 || (block = world.func_147439_a(i1, j1 - 1, k1)) != biome.field_76752_A && block != biome.field_76753_B || world.func_147439_a(i1, j1, k1).func_149721_r() || world.func_147439_a(i1, j1 + 1, k1).func_149721_r() || (bandit = (LOTREntityBandit)EntityList.func_75620_a((String)LOTREntities.getStringFromClass(banditClass), (World)world)) == null) continue;
                bandit.func_70012_b((double)i1 + 0.5, j1, (double)k1 + 0.5, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)bandit, (World)world, (float)((float)bandit.field_70165_t), (float)((float)bandit.field_70163_u), (float)((float)bandit.field_70161_v));
                if (canSpawn != Event.Result.ALLOW && (canSpawn != Event.Result.DEFAULT || !bandit.func_70601_bi())) continue;
                bandit.func_110161_a(null);
                world.func_72838_d((Entity)bandit);
                bandit.isNPCPersistent = false;
                if (++banditsSpawned >= maxBandits) continue block0;
            }
        }
    }

    public static enum EventChance {
        NEVER(0.0f, 0),
        RARE(0.1f, 3600),
        NOTRARE(0.2f, 3600),
        UNCOMMON(0.3f, 3600),
        HALFTIME(0.6f, 3600),
        COMMON(0.9f, 3600),
        UBELIEVEBLE(1.0f, 3600),
        BANDIT_RARE(0.1f, 3600),
        BANDIT_UNCOMMON(0.3f, 3600),
        BANDIT_HALFTIME(0.5f, 3600),
        BANDIT_COMMON(0.8f, 3600),
        BANDIT_UNBELIEVABLE(1.0f, 3600);

        public final double chancePerSecond;
        public final double[] chancesPerSecondPerChunk;

        private EventChance(float prob, int s) {
            this.chancePerSecond = EventChance.getChance(prob, s);
            this.chancesPerSecondPerChunk = new double[64];
            for (int i = 0; i < this.chancesPerSecondPerChunk.length; ++i) {
                this.chancesPerSecondPerChunk[i] = EventChance.getChance(this.chancePerSecond, i);
            }
        }

        public static double getChance(double prob, int trials) {
            if (prob == 0.0 || trials == 0) {
                return 0.0;
            }
            double d = prob;
            d = 1.0 - d;
            d = Math.pow(d, 1.0 / (double)trials);
            d = 1.0 - d;
            return d;
        }
    }
}

